/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import { highlightSelectorsInCode } from '../../../utils/SelectorsHighlighter';
import YasmAlert from '../../../components/YasmAlert';

class AlertProgram extends PureComponent {
  render() {
    const { projectId, code } = this.props;

    const highlightResult = highlightSelectorsInCode(projectId, code);

    const pre = (
      <pre style={{ whiteSpace: 'pre-wrap' }}>
        {highlightResult.result}
      </pre>
    );

    let yasmAlert = null;

    if (/project\s*==?\s*(["'])?yasm_/.exec(code) !== null) {
      yasmAlert = <YasmAlert />;
    }

    let notSupportedSelectorsAlert = null;

    if (!highlightResult.allReplaced) {
      notSupportedSelectorsAlert = (
        <div className="alert alert-warning">
          Some selectors in program are not clickable, because now Solomon cannot plot graph.
        </div>
      );
    }

    return (
      <div>
        {pre}
        {notSupportedSelectorsAlert}
        {yasmAlert}
      </div>
    );
  }
}

AlertProgram.propTypes = {
  projectId: PropTypes.string.isRequired,
  code: PropTypes.string.isRequired,
};

export default AlertProgram;
