import React from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import { ALERT_EVAL_STATUSES } from '../../constants';
import LabeledValue from '../../../../components/LabeledValue';
import Panel from '../../../../components/Panel';

const MultiAlertEvalStatsPanel = ({ projectId, alertId, evalStats }) => {
  const stats = evalStats.evaluationStats;

  const labels = ALERT_EVAL_STATUSES.map((status) => {
    const stat = stats[status.statsName] || 0;

    if (!stat) {
      return null;
    }

    const labelEl = (
      <Link to={`/admin/projects/${projectId}/alerts/${alertId}/subAlerts?filterByEvalStatus=${status.value}`}>
        <span className={`label label-${status.style}`}>{stat}</span>
      </Link>
    );

    return (
      <LabeledValue
        key={status.statsName}
        label={status.title}
        value={labelEl}
      />
    );
  })
    .filter(Boolean);

  return (
    <Panel title="Evaluation stats">
      {labels}
      <p>
        <Link to={`/admin/projects/${projectId}/alerts/${alertId}/subAlerts`}>
          Show all subalerts
        </Link>
      </p>
    </Panel>
  );
};

MultiAlertEvalStatsPanel.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  evalStats: PropTypes.object.isRequired,
};

export default MultiAlertEvalStatsPanel;
