import React from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import { NOTIFICATION_STATUSES } from '../../constants';
import LabeledValue from '../../../../components/LabeledValue';
import Panel from '../../../../components/Panel';

const MultiAlertNotificationStatsPanel = ({ projectId, alertId, notificationStats }) => {
  const stats = notificationStats.notificationStats;

  const labels = NOTIFICATION_STATUSES
    .filter((status) => status.value !== 'UNKNOWN')
    .map((status) => {
      const stat = stats[status.lowerValue];

      if (!stat) {
        return null;
      }

      const labelEl = (
        <Link to={`/admin/projects/${projectId}/alerts/${alertId}/subAlertsNotifications?filterByNotificationStatus=${status.value}`}>
          <span className={`label ${status.style}`}>{stat}</span>
        </Link>
      );

      return (
        <LabeledValue
          key={status.lowerValue}
          label={status.title}
          value={labelEl}
        />
      );
    })
    .filter(Boolean);

  if (labels.length > 0) {
    return (
      <Panel title="Notification stats">
        {labels}
        <p>
          <Link to={`/admin/projects/${projectId}/alerts/${alertId}/subAlertsNotifications`}>
            Show all subalerts notifications
          </Link>
        </p>
      </Panel>
    );
  }

  return null;
};

MultiAlertNotificationStatsPanel.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  notificationStats: PropTypes.object.isRequired,
};

export default MultiAlertNotificationStatsPanel;
