import React from 'react';
import PropTypes from 'prop-types';
import isEmpty from 'lodash/isEmpty';

import MultiAlertEvalStatsPanel from './MultiAlertEvalStatsPanel';
import MultiAlertNotificationStatsPanel from './MultiAlertNotificationStatsPanel';

const MultiAlertStatsBlock = ({
  projectId, alertId, evalStats, notificationStats,
}) => {
  let evalStatsBlock = null;
  let notificationStatsBlock = null;

  if (!isEmpty(evalStats)) {
    evalStatsBlock = (
      <MultiAlertEvalStatsPanel
        projectId={projectId}
        alertId={alertId}
        evalStats={evalStats}
      />
    );
  }

  if (!isEmpty(notificationStats)) {
    notificationStatsBlock = (
      <MultiAlertNotificationStatsPanel
        projectId={projectId}
        alertId={alertId}
        notificationStats={notificationStats}
      />
    );
  }

  return (
    <div>
      {evalStatsBlock}
      {notificationStatsBlock}
    </div>
  );
};

MultiAlertStatsBlock.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  evalStats: PropTypes.object.isRequired,
  notificationStats: PropTypes.object.isRequired,
};

export default MultiAlertStatsBlock;
