/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';

import { ALERT_EVAL_STATUS } from '../constants';
import FullscreenFlexableSinglestat from '../../../components/Tiles/FullscreenFlexableSinglestat';
import './style.css';

const AlertSinglestat = ({
  projectId, alertId, evalState, annotationKeys, isTargetBlank, element,
}) => {
  const status = evalState.status || {};

  const evalStatus = ALERT_EVAL_STATUS[status.code];

  const title = evalStatus ? evalStatus.title : 'Unknown';

  const filteredAnnotationKeys = annotationKeys.filter((ann) => ann !== 'trafficLight.color');

  const annotations = status.annotations || {};

  const hasTrafficLightColor = annotationKeys.indexOf('trafficLight.color') >= 0;

  const trafficLightColor = annotations['trafficLight.color'];

  let code;

  if (hasTrafficLightColor && trafficLightColor) {
    code = trafficLightColor.toUpperCase();
  } else {
    code = status.code;
  }

  const url = `/admin/projects/${projectId}/alerts/${alertId}`;

  const labels = hasTrafficLightColor ? [] : [title];

  const values = filteredAnnotationKeys.map((ann) => annotations[ann] || '-');

  const tile = {
    id: alertId,
    labels,
    values,
    url,
    color: code,
    mute: evalState.muteStatus.code,
  };

  return (
    <FullscreenFlexableSinglestat element={element} tile={tile} fullscreen={isTargetBlank} />
  );
};

AlertSinglestat.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  evalState: PropTypes.object.isRequired,
  annotationKeys: PropTypes.arrayOf(PropTypes.string).isRequired,
  isTargetBlank: PropTypes.bool.isRequired,
  element: PropTypes.element,
};

AlertSinglestat.defaultProps = {
  element: null,
};

export default AlertSinglestat;
