/* eslint-disable jsx-a11y/interactive-supports-focus */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { ALERT_EVAL_STATUSES } from '../constants';

class AlertOption extends PureComponent {
  handleMouseDown = (event) => {
    event.preventDefault();
    event.stopPropagation();
    this.props.onSelect(this.props.option, event);
  };

  handleMouseEnter = (event) => {
    this.props.onFocus(this.props.option, event);
  };

  handleMouseMove = (event) => {
    if (this.props.isFocused) {
      return;
    }
    this.props.onFocus(this.props.option, event);
  };

  render() {
    const { option, className } = this.props;

    let optionContent = null;

    if (option.id) {
      let evalStats = null;

      if (option.evaluationStats) {
        evalStats = (
          <div style={{ float: 'right', verticalAlign: 'middle' }}>
            {ALERT_EVAL_STATUSES.map((evalStatus) => {
              const count = option.evaluationStats[evalStatus.statsName];

              let evalContent = null;

              if (count) {
                evalContent = (
                  <span
                    key={evalStatus.statsName}
                    className={`label label-${evalStatus.style}`}
                    style={{ marginRight: '2px' }}
                  >
                    {count}
                  </span>
                );
              }

              return evalContent;
            })}
          </div>
        );
      }

      optionContent = (
        <div>
          {option.name}
          <br />
          <small>{option.id}</small>
          {evalStats}
        </div>
      );
    } else {
      optionContent = option.value;
    }

    return (
      <div className={className}>
        <div
          onMouseDown={this.handleMouseDown}
          onMouseEnter={this.handleMouseEnter}
          onMouseMove={this.handleMouseMove}
          role="button"
          title={option.name}
        >
          {optionContent}
        </div>
      </div>
    );
  }
}

AlertOption.propTypes = {
  className: PropTypes.string.isRequired,
  isFocused: PropTypes.bool.isRequired,
  onFocus: PropTypes.func.isRequired,
  onSelect: PropTypes.func.isRequired,
  option: PropTypes.object.isRequired,
};

export default AlertOption;
