import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Select from 'react-select';
import { fetchAlerts } from '../../../api/alerts';
import AlertOption from './AlertOption';

class AlertSuggest extends PureComponent {
  static filterOptions() {
    return true;
  }

  handleChange = (options) => {
    const newValues = options.map((option) => option.value);
    this.props.onChange(newValues);
  };

  handleValueClick = (option) => {
    window.open(`/admin/projects/${this.props.projectId}/alerts/${option.value}`);
  };

  loadOptions = (input, callback) => {
    fetchAlerts(this.props.projectId, { filterByName: input, pageSize: 50 })
      .then((result) => {
        const items = result.items || [];

        const options = items.map((item) => ({
          value: item.id,
          name: item.name,
          evaluationStats: item.evaluationStats,
          id: item.id,
        }));
        callback(null, { options, complete: true });

        return Promise.resolve();
      });
  };

  render() {
    const { values } = this.props;

    const options = values.map((value) => ({ label: value, value }));

    return (
      <Select.AsyncCreatable
        multi
        value={options}
        optionComponent={AlertOption}
        loadOptions={this.loadOptions}
        filterOption={AlertSuggest.filterOptions}
        onChange={this.handleChange}
        onValueClick={this.handleValueClick}
        placeholder="Alerts..."
        isSearchable
      />
    );
  }
}

AlertSuggest.propTypes = {
  projectId: PropTypes.string.isRequired,
  values: PropTypes.array,
  onChange: PropTypes.func.isRequired,
};

AlertSuggest.defaultProps = {
  values: [],
};

export default AlertSuggest;
