import values from 'lodash/values';
import { roundNumericString } from '../../../utils/number';

function getValueFromAnnotations(annotations) {
  if (annotations) {
    const value = annotations['trafficLight.value'] || '-';

    return roundNumericString(value);
  }

  return '-';
}

function getColorFromEvalState(statusCode, annotations) {
  if (annotations) {
    const color = annotations['trafficLight.color'] || '';

    if (color) {
      return color.toUpperCase();
    }
  }

  return statusCode;
}

function mapAlertWithStateToTiles(alertWithState) {
  const { alert, evalState, subAlerts } = alertWithState;

  const alertName = alert.name;
  const alertUrl = `/admin/projects/${alert.projectId}/alerts/${alert.id}`;

  if (evalState) {
    const value = getValueFromAnnotations(evalState.status.annotations);
    const color = getColorFromEvalState(evalState.status.code, evalState.status.annotations);

    return [{
      labels: [alertName],
      values: [value],
      url: alertUrl,
      color,
      mute: evalState.muteStatus.code,
    }];
  }

  if (subAlerts) {
    return subAlerts.map((subAlert) => {
      const value = getValueFromAnnotations(subAlert.annotations);
      const color = getColorFromEvalState(subAlert.evaluationStatusCode, subAlert.annotations);

      const subAlertUrl = `${alertUrl}/subAlerts/${subAlert.id}`;

      return {
        labels: [alertName, ...values(subAlert.labels)],
        values: [value],
        url: subAlertUrl,
        color,
        mute: subAlert.muteStatusCode,
      };
    });
  }

  return [];
}

function mapAlertEvalStatesToTiles(data) {
  let tiles = data
    .map((alertWithState) => mapAlertWithStateToTiles(alertWithState))
    .reduce((a, b) => [...a, ...b], []);

  if (tiles.every((tile) => tile.values[0] === '-')) {
    tiles = tiles.map((tile) => ({ ...tile, values: [] }));
  }

  return tiles;
}

export default mapAlertEvalStatesToTiles;
