import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import Breadcrumb from '../../components/Breadcrumb/Breadcrumb';
import PageTitle from '../../components/PageTitle';

import { wrapSubProjectReadPage } from '../projects/wrapSubProjectPage';

class AlertsNewAlertPage extends PureComponent {
  constructor(props) {
    super(props);
    this._projectId = props.match.params.projectId;
  }

  render() {
    return (
      <div>
        <Breadcrumb match={this.props.match} />
        <PageTitle title="Choose type of alert" />
        <div className="col-md-6 col-sm-6">
          <div className="card">
            <div className="card-body">
              <h5 className="card-title">From template</h5>
              <p className="card-text">Create standard alert for services like MDB, YT, YDB...</p>
              <Link to={`/admin/projects/${this._projectId}/alerts/templates`} className="btn btn-outline btn-success">
                Create from template
              </Link>
            </div>
          </div>
        </div>
        <div className="col-md-6 col-sm-6">
          <div className="card">
            <div className="card-body">
              <h5 className="card-title">Custom</h5>
              <p className="card-text">Create custom threshold or expression alert and configure it by yourself.</p>
              <Link to={`/admin/projects/${this._projectId}/alerts/new?aType=custom`} className="btn btn-outline btn-success">
                Create custom
              </Link>
            </div>
          </div>
        </div>
      </div>
    );
  }
}

AlertsNewAlertPage.propTypes = {
  match: PropTypes.object.isRequired,
};

export default wrapSubProjectReadPage(AlertsNewAlertPage);
