import React from 'react';
import PropTypes from 'prop-types';

import { NOTIFICATION_STATUSES } from '../constants';

const NotificationStats = ({ stats }) => (
  <ul className="labels-list">
    {NOTIFICATION_STATUSES.map((status) => {
      const stat = stats[status.lowerValue];

      if (!stat) {
        return null;
      }

      return (
        <li key={status.lowerValue}>
          <span className={`label ${status.style}`}>
            {status.title}
            :
            {stat}
          </span>
        </li>
      );
    })
      .filter(Boolean)}
  </ul>
);

NotificationStats.propTypes = {
  stats: PropTypes.object.isRequired,
};

export default NotificationStats;
