import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import NotificationStats from './NotificationStats';

class SubAlertsTable extends PureComponent {
  render() {
    const {
      projectId, alertId, groupByLabels, subAlerts,
    } = this.props;

    return (
      <table className="table table-considered table-hover">
        <thead>
          <tr>
            <th>Notification stats</th>
            <th>Sub alert</th>
          </tr>
        </thead>
        <tbody>
          {subAlerts.map((subAlert) => {
            const labelsMap = subAlert.labels || {};

            const subAlertTitle = groupByLabels.map((label) => `${label}=${labelsMap[label] || '-'}`).join(', ');

            return (
              <tr key={subAlert.id}>
                <td>
                  <NotificationStats stats={subAlert.notificationStats} />
                </td>
                <td>
                  <Link to={`/admin/projects/${projectId}/alerts/${alertId}/subAlerts/${subAlert.id}`}>
                    {subAlertTitle}
                  </Link>
                </td>
              </tr>
            );
          })}
        </tbody>
      </table>
    );
  }
}

SubAlertsTable.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  groupByLabels: PropTypes.array.isRequired,
  subAlerts: PropTypes.array.isRequired,
};

export default SubAlertsTable;
