/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import {
  convertOldToNewSelectors,
  convertSelectorsToOldFormat,
  mergeProgramSelectorsAndLabels,
} from '../../../utils/SelectorUtils';
import {
  LOAD1_PART_TYPE,
  replaceSelectorsInCode,
  SELECTORS_PART_TYPE,
} from '../../../utils/SelectorsReplacer';
import Selectors from '../../../utils/Selectors';
import { doubleQuote } from '../../../utils/Quoter';
import { highlightSelectorsInCode } from '../../../utils/SelectorsHighlighter';
import YasmAlert from '../../../components/YasmAlert';

/**
 * It's necessary to parse program manually, because API functionality
 * to get program for sub alert isn't implemented yet.
 *
 * TODO (rorewillo@): implement SOLOMON-3419 and drop this component
 */
class SubAlertProgram extends PureComponent {
  _overrideSelectorsByLabelsKey = (type, text, selectors) => {
    let parsedSelectors;
    if (type === SELECTORS_PART_TYPE) {
      parsedSelectors = Selectors.parse(selectors);
    } else {
      parsedSelectors = convertOldToNewSelectors(selectors);
    }

    const fixedSelectors = mergeProgramSelectorsAndLabels(parsedSelectors, this.props.labels);

    let fixedSelectorsStr;
    if (type === SELECTORS_PART_TYPE) {
      fixedSelectorsStr = fixedSelectors.format(true);
    } else {
      const formattedOldSelectors = convertSelectorsToOldFormat(fixedSelectors);
      const funcName = type === LOAD1_PART_TYPE ? 'load1' : 'load';
      fixedSelectorsStr = `${funcName}(${doubleQuote(formattedOldSelectors)})`;
    }

    return {
      part: fixedSelectorsStr,
      isOk: true,
    };
  };

  render() {
    const { projectId, code } = this.props;

    const newCode = replaceSelectorsInCode(code, this._overrideSelectorsByLabelsKey).result.join('');

    const highlightResult = highlightSelectorsInCode(projectId, newCode);

    const pre = (
      <pre style={{ whiteSpace: 'pre-wrap' }}>
        {highlightResult.result}
      </pre>
    );

    let yasmAlert = null;

    if (/project\s*==?\s*(["'])?yasm_/.exec(code) !== null) {
      yasmAlert = <YasmAlert />;
    }

    let notSupportedSelectorsAlert = null;

    if (!highlightResult.allReplaced) {
      notSupportedSelectorsAlert = (
        <div className="alert alert-warning">
          Some selectors in program are not clickable, because now Solomon cannot plot graph.
        </div>
      );
    }

    return (
      <div>
        {pre}
        {notSupportedSelectorsAlert}
        {yasmAlert}
      </div>
    );
  }
}

SubAlertProgram.propTypes = {
  projectId: PropTypes.string.isRequired,
  labels: PropTypes.object.isRequired,
  code: PropTypes.string.isRequired,
};

export default SubAlertProgram;
