import React from 'react';
import PropTypes from 'prop-types';

import { makeSolomonUrl } from './utils';
import ChartPanel from '../components/ChartPanel/ChartPanel';
import { projectForEnv, alertingClusterForEnv } from '../../../utils/env';

const ChannelStatusChart = ({ projectId, channelId }) => {
  const solomonUrl = makeSolomonUrl({
    project: projectForEnv,
    cluster: alertingClusterForEnv,
    service: 'alerting_statuses',
    'l.sensor': 'channel.notification.status',
    'l.projectId': projectId,
    'l.channelId': channelId,
    graph: 'auto',
    downsampling: 'byPoints',
    downsamplingAggr: 'last',
    maxPoints: '100',
    transform: 'diff',
  });

  const chartParams = {
    project: projectForEnv,
    cluster: alertingClusterForEnv,
    projectId,
    channelId,
  };

  return (
    <ChartPanel
      id="channel-status"
      title="Channel status"
      solomonUrl={solomonUrl}
      chartSource="/editor/solomon/alerting/channel-status"
      chartParams={chartParams}
    />
  );
};

ChannelStatusChart.propTypes = {
  projectId: PropTypes.string.isRequired,
  channelId: PropTypes.string.isRequired,
};

export default ChannelStatusChart;
