import React from 'react';
import PropTypes from 'prop-types';

import { makeSolomonUrl } from './utils';

import ChartPanel from '../components/ChartPanel/ChartPanel';
import { projectForEnv, alertingClusterForEnv } from '../../../utils/env';

const MultiAlertStatusChart = ({ projectId, alertId }) => {
  const solomonUrl = makeSolomonUrl({
    project: projectForEnv,
    cluster: alertingClusterForEnv,
    service: 'alerting_statuses',
    'l.sensor': 'multiAlert.evaluation.status',
    'l.projectId': projectId,
    'l.alertId': alertId,
    graph: 'auto',
    downsamplingAggr: 'last',
  });

  const chartParams = {
    project: projectForEnv,
    cluster: alertingClusterForEnv,
    projectId,
    alertId,
  };

  return (
    <ChartPanel
      id="multi-alert-status"
      title="Multi alert status"
      solomonUrl={solomonUrl}
      chartSource="/editor/solomon/alerting/multialert-status-2"
      chartParams={chartParams}
    />
  );
};

MultiAlertStatusChart.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
};

export default MultiAlertStatusChart;
