import { parseDuration } from '../../../../utils/duration';

export function computeTimeRangeImpl(params) {
  const durationMs = parseDuration(params.b, true) || 86400000;
  const now = Date.now();
  return { fromMillis: now - durationMs, toMillis: now };
}

function isEmptyOrZero(data, filterZeroSeries) {
  return data.length === 0 || data.every((v) => isNaN(v[1]) || (filterZeroSeries && (v[1] === 0)));
}

function convertElementToTimeseries(el) {
  const { timeseries } = el;
  const { labels } = timeseries;
  const data = Array(timeseries.values.length);

  const values = timeseries.values || [];
  const timestamps = timeseries.timestamps || [];

  for (let i = 0; i < values.length; ++i) {
    let value = values[i];
    if (isNaN(value) || !Number.isFinite(value)) {
      value = NaN;
    }
    data[i] = [timestamps[i], value];
  }

  return { labels, data };
}

export function prepareLoadedData(loadedData, filterZeroSeries) {
  if (!loadedData || !loadedData.vector) {
    return [];
  }
  return loadedData.vector
    .map((el) => convertElementToTimeseries(el))
    .filter((timeseries) => !isEmptyOrZero(timeseries.data, filterZeroSeries));
}

export default {};
