import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import AlertExplanation from '../../components/AlertExplanation/AlertExplanation';
import AlertEvalStatusLabel from '../../components/AlertEvalStatusLabel';

class AlertExplanationPanel extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { memState: { selected: 0 } };
  }

  render() {
    const { explanation } = this.props;

    let alertStatus = null;

    if (!explanation.loading && explanation.data) {
      alertStatus = (
        <span style={{ marginLeft: '5px' }}>
          <AlertEvalStatusLabel statusCode={explanation.data.status.code} />
        </span>
      );
    }

    const { memState } = this.state;

    return (
      <div className="panel panel-default">
        <div className="panel-heading">
          Alert chart
          {alertStatus}
        </div>
        <div style={{ minHeight: '310px', padding: '5px' }}>
          <AlertExplanation explanation={explanation} memState={memState} showScalars />
        </div>
      </div>
    );
  }
}

AlertExplanationPanel.propTypes = {
  explanation: PropTypes.object.isRequired,
};

export default AlertExplanationPanel;
