/* eslint-disable jsx-a11y/no-static-element-interactions */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import AlertExplanationPanel from './AlertExplanationPanel';
import SingleAlertStatusChart from './SingleAlertStatusChart';

class SingleAlertStatus extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { range: '1h', time: 0 };
  }

  handleStatusChartClick = (ts) => {
    this.props.loadExplanation(ts);
  };

  handleRangeChange = ({ range, time }) => {
    this.setState({ range, time });
  };

  render() {
    const {
      projectId, parentId, alertId, explanation,
    } = this.props;

    return (
      <div>
        <SingleAlertStatusChart
          projectId={projectId}
          parentId={parentId}
          alertId={alertId}
          range={this.state.range}
          time={this.state.time}
          onRangeChange={this.handleRangeChange}
          onTimeClick={this.handleStatusChartClick}
        />
        <AlertExplanationPanel explanation={explanation} />
      </div>
    );
  }
}

SingleAlertStatus.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  parentId: PropTypes.string,
  explanation: PropTypes.object.isRequired,
  loadExplanation: PropTypes.func.isRequired,
};

SingleAlertStatus.defaultProps = {
  parentId: '-',
};

export default SingleAlertStatus;
