import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class AffectingMutes extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { };
  }

  render() {
    const { projectId, mutes } = this.props;

    return (
      <div>
        {mutes
          .map((mute) => <span>{`${projectId}/${mute}`}</span>)
          .reduce((prev, curr) => [prev, ', ', curr])}
      </div>
    );
  }
}

AffectingMutes.propTypes = {
  projectId: PropTypes.string.isRequired,
  mutes: PropTypes.arrayOf(PropTypes.string),
};

AffectingMutes.defaultProps = {
  mutes: [],
};

export default AffectingMutes;
