import React from 'react';
import PropTypes from 'prop-types';
import isEmpty from 'lodash/isEmpty';
import { Link } from 'react-router-dom';

import Panel from '../../../components/Panel';
import LabeledValue from '../../../components/LabeledValue';
import LocalDate from '../../../components/LocalDate';
import AlertStatus from './AlertStatus';

const AlertEvalInfo = ({
  projectId, alertId, subAlertId, evalState,
}) => {
  if (isEmpty(evalState)) {
    return null;
  }

  const singlestatUrl = subAlertId
    ? `/admin/projects/${projectId}/alerts/${alertId}/subAlerts/${subAlertId}/singlestat`
    : `/admin/projects/${projectId}/alerts/${alertId}/singlestat`;

  return (
    <Panel title="Evaluation">
      <LabeledValue label="Status" value={<AlertStatus status={evalState.status} />} />
      {!isEmpty(evalState.previousStatus)
        && (
        <LabeledValue
          label="Previous status"
          value={<AlertStatus status={evalState.previousStatus} />}
        />
        )}
      <LabeledValue label="Evaluated at" value={<LocalDate date={evalState.latestEval} />} />
      <LabeledValue label="Since" value={<LocalDate date={evalState.since} />} />
      <LabeledValue value={(<Link to={singlestatUrl}>Show singlestat</Link>)} />
    </Panel>
  );
};

AlertEvalInfo.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  subAlertId: PropTypes.string,
  evalState: PropTypes.object,
};

AlertEvalInfo.defaultProps = {
  subAlertId: '',
  evalState: {},
};

export default AlertEvalInfo;
