import React from 'react';
import PropTypes from 'prop-types';
import { ALERT_EVAL_STATUS } from '../constants';

const AlertEvalStatusLabel = ({ statusCode }) => {
  const status = ALERT_EVAL_STATUS[statusCode];

  const style = status ? status.style : 'default';
  const title = status ? status.title : '(unknown)';

  return (<span className={`label label-${style}`}>{title}</span>);
};

AlertEvalStatusLabel.propTypes = {
  statusCode: PropTypes.string.isRequired,
};

export default AlertEvalStatusLabel;
