import React from 'react';
import PropTypes from 'prop-types';
import { ALERT_EVAL_STATUS } from '../constants';

const STATUS_OPTIONS = [
  ALERT_EVAL_STATUS.ALARM,
  ALERT_EVAL_STATUS.WARN,
  ALERT_EVAL_STATUS.OK,
  ALERT_EVAL_STATUS.NO_DATA,
  ALERT_EVAL_STATUS.ERROR,
];

export default class AlertEvalStatuses extends React.Component {
  handleClick = (event) => {
    event.preventDefault();

    const { name } = event.target;

    let nextValues;

    const nameIndex = this.props.values.indexOf(name);
    if (nameIndex < 0) {
      nextValues = [...this.props.values, name];
    } else {
      nextValues = [...this.props.values];
      nextValues.splice(nameIndex, 1);
    }

    this.props.onChange(nextValues);
  };

  render() {
    const { values, editable } = this.props;

    if (editable) {
      const buttons = STATUS_OPTIONS.map((status) => (
        <button
          key={status.value}
          name={status.value}
          type="button"
          className={values.indexOf(status.value) >= 0 ? 'btn btn-default active' : 'btn btn-default'}
          onClick={this.handleClick}
        >
          {status.title}
        </button>
      ));

      return (
        <div className="btn-group">
          {buttons}
        </div>
      );
    }

    if (values.length === 0) {
      return '(not selected)';
    }

    return (
      <ul className="labels-list">
        {STATUS_OPTIONS.map((status) => {
          if (values.indexOf(status.value) < 0) {
            return null;
          }

          return (
            <li key={status.value}>
              <span className={`label label-${status.style}`}>{status.title}</span>
            </li>
          );
        })}
      </ul>
    );
  }
}

AlertEvalStatuses.propTypes = {
  values: PropTypes.array.isRequired,
  onChange: PropTypes.func,
  editable: PropTypes.bool,
};

AlertEvalStatuses.defaultProps = {
  onChange: null,
  editable: false,
};
