import React from 'react';
import PropTypes from 'prop-types';

import HighchartsChart from '../../../../components/HighchartsChart/HighchartsChart';

function calcMarkerSize(series) {
  let markerSize = 0;
  let minLen = Number.MAX_SAFE_INTEGER;
  let maxLen = 0;
  for (let i = 0; i < series.length; i++) {
    const serie = series[i];
    if (serie.data && serie.data.length) {
      minLen = Math.min(minLen, serie.data.length);
      maxLen = Math.max(maxLen, serie.data.length);
    }
  }

  if (maxLen === 1) {
    markerSize = 10;
  } else if (minLen < 30) {
    markerSize = 4;
  }

  return markerSize;
}

const LineChart = ({ series, height, config }) => {
  if (!series || series.length === 0) {
    return null;
  }

  const markerSize = calcMarkerSize(series);

  const highchartsOptions = {
    title: '',
    series,
    xAxis: { type: 'datetime', gridLineWidth: 1 },
    yAxis: { title: '' },
    legend: {
      layout: 'vertical',
      align: 'right',
      verticalAlign: 'middle',
      itemStyle: { fontWeight: 'normal' },
    },
    chart: { height: `${height}px`, type: config.stack ? 'area' : 'line' },
    plotOptions: {
      area: {
        stacking: 'normal',
      },
      series: {
        animation: false,
        marker: {
          enabled: markerSize > 0,
          radius: markerSize,
        },
      },
    },
    tooltip: {
      backgroundColor: 'white',
    },
    credits: {
      enabled: false,
    },
    time: {
      useUTC: false,
    },
  };

  return <HighchartsChart options={highchartsOptions} />;
};

LineChart.propTypes = {
  series: PropTypes.array,
  height: PropTypes.number,
  config: PropTypes.object,
};

LineChart.defaultProps = {
  series: [],
  height: 250,
  config: { stack: false },
};

export default LineChart;
