import React from 'react';
import PropTypes from 'prop-types';
import HighchartsChart from '../../../../components/HighchartsChart/HighchartsChart';

const PieChart = ({ series }) => {
  if (!series || series.length === 0) {
    return null;
  }

  const options = {
    title: '',
    series: [{ data: series }],
    tooltip: {
      backgroundColor: 'rgba(0, 0, 0, 200)',
      style: {
        color: 'white',
      },
      pointFormat: '{point.y:.1f}: <b>{point.percentage:.1f}%</b>',
    },
    chart: {
      plotBackgroundColor: null,
      plotBorderWidth: null,
      plotShadow: false,
      height: '250px',
      type: 'pie',
    },
    plotOptions: {
      pie: {
        allowPointSelect: true,
        cursor: 'pointer',
        dataLabels: {
          enabled: true,
          format: '<b>{point.name}</b> {point.percentage:.1f}%',
        },
      },
    },
    credits: {
      enabled: false,
    },
  };

  return <HighchartsChart options={options} />;
};

PieChart.propTypes = {
  series: PropTypes.array,
};

PieChart.defaultProps = {
  series: [],
};

export default PieChart;
