import React from 'react';
import PropTypes from 'prop-types';
import { ALERT_SEVERITIES } from '../constants';

const SEVERITIES_OPTIONS = [
  ALERT_SEVERITIES.DISASTER,
  ALERT_SEVERITIES.CRITICAL,
  ALERT_SEVERITIES.INFO,
];

export default class AlertSeverities extends React.Component {
  handleClick = (event) => {
    event.preventDefault();

    const { name } = event.target;

    let nextValues;

    const nameIndex = this.props.values.indexOf(name);
    if (nameIndex < 0) {
      nextValues = [...this.props.values, name];
    } else {
      nextValues = [...this.props.values];
      nextValues.splice(nameIndex, 1);
    }

    this.props.onChange(nextValues);
  };

  render() {
    const { values, editable } = this.props;

    if (editable) {
      const buttons = SEVERITIES_OPTIONS.map((severity) => (
        <button
          key={severity.value}
          name={severity.value}
          type="button"
          className={values.indexOf(severity.value) >= 0 ? 'btn btn-default active' : 'btn btn-default'}
          onClick={this.handleClick}
        >
          {severity.title}
        </button>
      ));

      return (
        <div className="btn-group">
          {buttons}
        </div>
      );
    }

    if (values.length === 0) {
      return '(not selected)';
    }

    return (
      <ul className="labels-list">
        {SEVERITIES_OPTIONS.map((severity) => {
          if (values.indexOf(severity.value) < 0) {
            return null;
          }

          return (
            <li key={severity.value}>
              <span className={`label label-${severity.style}`}>{severity.title}</span>
            </li>
          );
        })}
      </ul>
    );
  }
}

AlertSeverities.propTypes = {
  values: PropTypes.array.isRequired,
  onChange: PropTypes.func,
  editable: PropTypes.bool,
};

AlertSeverities.defaultProps = {
  onChange: null,
  editable: false,
};
