import React from 'react';
import PropTypes from 'prop-types';

import Select from 'react-select';
import 'react-select/dist/react-select.min.css';

const AnnotationSuggest = ({ annotations, selectedValues, onChange }) => {
  if (annotations.length > 0) {
    const options = annotations.map((ann) => ({ value: ann, label: ann }));

    return (
      <div className="btn-group" style={{ width: '300px' }}>
        <Select
          multi
          value={selectedValues.join(',')}
          options={options}
          onChange={onChange}
          placeholder="Annotations..."
        />
      </div>
    );
  }

  return null;
};

AnnotationSuggest.propTypes = {
  annotations: PropTypes.array.isRequired,
  selectedValues: PropTypes.array.isRequired,
  onChange: PropTypes.func.isRequired,
};

export default AnnotationSuggest;
