import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import { formatSearch } from '../../../../utils/url';

import RadioButtons from '../../../../components/RadioButtons';
import LinksModal from './LinksModal';
import PseudoChartkitChart from '../../charts/PseudoChartkitChart/PseudoChartkitChart';

class ChartPanel extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { b: '1d', modalShown: false };
  }

  handleRangeChange = (b) => {
    this.setState({ b });
  };

  handleShowLinksClick = (event) => {
    event.preventDefault();
    this.setState({ modalShown: true });
  };

  handleHideModal = () => {
    this.setState({ modalShown: false });
  };

  render() {
    const {
      title, solomonUrl, chartSource, chartParams, id,
    } = this.props;

    const preparedChartParams = { ...chartParams, b: this.state.b };
    const preparedSolomonUrl = `${solomonUrl}&b=${this.state.b}`;
    const preparedChartsUrl = `https://charts.yandex-team.ru/preview${chartSource}?${formatSearch(preparedChartParams)}`;

    const chart = <PseudoChartkitChart id={id} params={preparedChartParams} />;

    return (
      <div className="panel panel-default">
        <div className="panel-heading">
          <a href={preparedSolomonUrl}>{title}</a>
          &nbsp;
          <i role="button" tabIndex={-1} className="glyphicon glyphicon-link" onClick={this.handleShowLinksClick} />
          <div className="pull-right" style={{ marginTop: '-5px' }}>
            <RadioButtons
              choices={['1h', '1d', '7d', '31d', '365d']}
              labels={['Hour', 'Day', 'Week', 'Month', 'Year']}
              selected={this.state.b}
              onSelect={this.handleRangeChange}
              size="sm"
            />
          </div>
        </div>
        <div style={{ height: '170px' }}>
          {chart}
        </div>
        <LinksModal
          solomonUrl={preparedSolomonUrl}
          chartsUrl={preparedChartsUrl}
          isOpen={this.state.modalShown}
          onCancel={this.handleHideModal}
        />
      </div>
    );
  }
}

ChartPanel.propTypes = {
  title: PropTypes.string.isRequired,
  solomonUrl: PropTypes.string.isRequired,
  chartSource: PropTypes.string.isRequired,
  chartParams: PropTypes.object.isRequired,
  id: PropTypes.string,
};

ChartPanel.defaultProps = {
  id: '',
};

export default ChartPanel;
