/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { copyContent } from '../../../../utils/clipboard';

import './style.css';

class LinkTextArea extends PureComponent {
  handleCopy = (event) => {
    event.preventDefault();
    copyContent(this.props.value);
  };

  render() {
    const { value, rows } = this.props;

    return (
      <div className="input-with-copy-group">
        <textarea
          className="form-control"
          value={value}
          rows={rows}
          readOnly
          style={{ resize: 'none' }}
        />
        <span className="copy-addon">
          <button type="button" className="btn btn-default" onClick={this.handleCopy}>
            <i className="glyphicon glyphicon-copy" />
          </button>
        </span>
      </div>
    );
  }
}

LinkTextArea.propTypes = {
  value: PropTypes.string.isRequired,
  rows: PropTypes.number.isRequired,
};

export default LinkTextArea;
