/* eslint-disable max-classes-per-file */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Modal from '../../../../components/Modal';
import { TabPane, Tabs } from '../../../../components/Tabs';
import LinkTextArea from './LinkTextArea';

const SolomonForm = ({ url }) => (
  <div className="form">
    <div className="form-group">
      <LinkTextArea value={url} rows={5} />
    </div>
  </div>
);

SolomonForm.propTypes = {
  url: PropTypes.string.isRequired,
};

class ChartsForm extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { withoutHeader: true };
  }

  handleCheckboxChange = (event) => {
    this.setState({ [event.target.name]: event.target.checked });
  };

  render() {
    let resultUrl = this.props.url;

    if (this.state.withoutHeader) {
      resultUrl = `${resultUrl}&_embedded=1`;
    }

    return (
      <div className="form">
        <div className="form-group">
          <LinkTextArea value={resultUrl} rows={5} />
        </div>
        <div className="form-group">
          <div className="checkbox">
            <label htmlFor="withoutHeader">
              <input
                type="checkbox"
                id="withoutHeader"
                name="withoutHeader"
                checked={this.state.withoutHeader}
                onChange={this.handleCheckboxChange}
              />
              {' '}
              Without header
            </label>
          </div>
        </div>
      </div>
    );
  }
}

ChartsForm.propTypes = {
  url: PropTypes.string.isRequired,
};

const WikiForm = ({ url }) => {
  const wikiCode = `{{iframe frameborder="0" width="100%" height="400px" src="${url}&_embedded=1"}}`;

  return (
    <div className="form">
      <div className="form-group">
        <LinkTextArea value={wikiCode} rows={4} />
      </div>
    </div>
  );
};

WikiForm.propTypes = {
  url: PropTypes.string.isRequired,
};

class LinksModal extends PureComponent {
  render() {
    const { isOpen, solomonUrl, chartsUrl } = this.props;

    return (
      <Modal title="Links" isOpen={isOpen} onCancel={this.props.onCancel} large>
        <Tabs vertical>
          <TabPane label="Solomon">
            <SolomonForm url={solomonUrl} />
          </TabPane>
          <TabPane label="Charts">
            <ChartsForm url={chartsUrl} />
          </TabPane>
          <TabPane label="Wiki">
            <WikiForm url={chartsUrl} />
          </TabPane>
        </Tabs>
      </Modal>
    );
  }
}

LinksModal.propTypes = {
  solomonUrl: PropTypes.string.isRequired,
  chartsUrl: PropTypes.string.isRequired,
  isOpen: PropTypes.bool.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default LinksModal;
