import React from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import { NOTIFICATION_STATUSES } from '../constants';

const ClickableNotificationStats = ({
  projectId, alertId, multiAlert, stats,
}) => (
  <ul className="labels-list">
    {NOTIFICATION_STATUSES.map((status) => {
      const stat = stats[status.lowerValue];

      if (!stat) {
        return null;
      }

      let url;

      if (multiAlert) {
        url = `/admin/projects/${projectId}/alerts/${alertId}/subAlertsNotifications?filterByNotificationStatus=${status.value}`;
      } else {
        url = `/admin/projects/${projectId}/alerts/${alertId}`;
      }

      return (
        <li key={status.lowerValue}>
          <Link to={url}>
            <span className={`label ${status.style}`}>
              {status.title}
              :
              {stat}
            </span>
          </Link>
        </li>
      );
    })
      .filter(Boolean)}
  </ul>
);

ClickableNotificationStats.propTypes = {
  projectId: PropTypes.string.isRequired,
  alertId: PropTypes.string.isRequired,
  multiAlert: PropTypes.bool.isRequired,
  stats: PropTypes.object.isRequired,
};

export default ClickableNotificationStats;
