import React from 'react';
import PropTypes from 'prop-types';

const NOTIFICATION_STATUS_OPTIONS = [
  { value: 'ANY', title: 'Any status' },
  { value: 'SUCCESS', title: 'Success' },
  { value: 'ERROR', title: 'Error' },
  { value: 'INVALID_REQUEST', title: 'Invalid request' },
  { value: 'ABSENT_NOTIFICATION_CHANNEL', title: 'Absent channel' },
  { value: 'ERROR_ABLE_TO_RETRY', title: 'Retry error' },
  { value: 'RESOURCE_EXHAUSTED', title: 'Resource exhausted' },
];

const NotificationStatusSelector = ({ value, onChange }) => (
  <select
    className="form-control"
    value={value}
    onChange={onChange}
  >
    {NOTIFICATION_STATUS_OPTIONS.map((option) => (
      <option key={option.value} value={option.value}>
        {option.title}
      </option>
    ))}
  </select>
);

NotificationStatusSelector.propTypes = {
  value: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
};

export default NotificationStatusSelector;
