/* eslint-disable max-classes-per-file */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class ScalarTableReadonlyRow extends PureComponent {
  render() {
    const { value } = this.props;
    const val = ''.concat(value.value);
    return (
      <tr onClick={this.onClick}>
        <td>{value.name || ''}</td>
        <td>{val}</td>
        <td>{value.type || ''}</td>
      </tr>
    );
  }
}

ScalarTableReadonlyRow.propTypes = {
  value: PropTypes.object.isRequired,
};

export default ScalarTableReadonlyRow;
