export const NOTIFICATION_METHODS = {
  EMAIL: 'E-Mail',
  JUGGLER: 'Juggler',
  WEBHOOK: 'Webhook',
  SMS: 'SMS',
  TELEGRAM: 'Telegram',
  YA_CHATS: 'Yandex.Messenger',
  PHONE_CALL: 'Phone',
};

export function getNotificationMethod(method = {}) {
  if (method.email) {
    return NOTIFICATION_METHODS.EMAIL;
  } if (method.juggler) {
    return NOTIFICATION_METHODS.JUGGLER;
  } if (method.webhook) {
    return NOTIFICATION_METHODS.WEBHOOK;
  } if (method.sms) {
    return NOTIFICATION_METHODS.SMS;
  } if (method.telegram) {
    return NOTIFICATION_METHODS.TELEGRAM;
  } if (method.yaChats) {
    return NOTIFICATION_METHODS.YA_CHATS;
  } if (method.phoneCall) {
    return NOTIFICATION_METHODS.PHONE_CALL;
  }
  return null;
}

export const METHOD_OPTIONS = [
  { value: NOTIFICATION_METHODS.EMAIL, title: 'E-Mail' },
  { value: NOTIFICATION_METHODS.SMS, title: 'SMS' },
  { value: NOTIFICATION_METHODS.JUGGLER, title: 'Juggler' },
  { value: NOTIFICATION_METHODS.WEBHOOK, title: 'Webhook' },
  { value: NOTIFICATION_METHODS.TELEGRAM, title: 'Telegram' },
  { value: NOTIFICATION_METHODS.YA_CHATS, title: 'Yandex.Messenger' },
  { value: NOTIFICATION_METHODS.PHONE_CALL, title: 'Phone' },
];

export const STATUSES_OPTIONS = [
  { value: 'OK', title: 'OK' },
  { value: 'WARN', title: 'Warning' },
  { value: 'ALARM', title: 'Alarm' },
  { value: 'NO_DATA', title: 'No data' },
  { value: 'ERROR', title: 'Error' },
];
