import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import FormInput from '../../components/forms/FormInput';
import { strToLabels, labelsToStr } from '../../utils/labels';
import { inputTargetValue } from '../../utils/inputs';
import FormDatalist from '../../components/forms/FormDatalist';
import LabelsInput from './LabelsInput';

const CLOUD_ENVS = [
  'PROD',
  'PREPROD',
  'HWLAB',
  'TESTING',
  'ISRAEL',
];

class ClusterHostCloudDnsForm extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      env: props.env,
      name: props.name,
      labels: labelsToStr(props.labels),
    };
    if (props.onSubmit) {
      this.onSubmit = (event) => {
        event.preventDefault();
        props.onSubmit(this.stateToValue());
      };
    }
  }

  onInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    const value = inputTargetValue(target);
    this.setState({ [name]: value });
  };

  stateToValue() {
    const { env, name, labels } = this.state;
    return {
      env,
      name,
      labels: strToLabels(labels),
    };
  }

  render() {
    const { env, name, labels } = this.state;
    return (
      <form className="form-horizontal" onSubmit={this.onSubmit}>
        <FormDatalist
          type="text"
          name="env"
          label="Environment"
          value={env}
          datalist={CLOUD_ENVS}
          onChange={this.onInputChange}
        />
        <FormInput
          type="text"
          name="name"
          label="Resource Name"
          value={name}
          onChange={this.onInputChange}
        />
        <LabelsInput
          value={labels}
          onChange={this.onInputChange}
        />
      </form>
    );
  }
}

ClusterHostCloudDnsForm.propTypes = {
  env: PropTypes.string,
  name: PropTypes.string,
  labels: PropTypes.arrayOf(PropTypes.string),
  onSubmit: PropTypes.func,
};

ClusterHostCloudDnsForm.defaultProps = {
  onSubmit: null,
  env: '',
  name: '',
  labels: [],
};

export default ClusterHostCloudDnsForm;
