import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import FormInput from '../../components/forms/FormInput';
import { strToLabels, labelsToStr } from '../../utils/labels';
import { inputTargetValue } from '../../utils/inputs';
import LabelsInput from './LabelsInput';

class ClusterHostConductorForm extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      group: props.group,
      labels: labelsToStr(props.labels),
    };
    if (props.onSubmit) {
      this.onSubmit = (event) => {
        event.preventDefault();
        props.onSubmit(this.stateToValue());
      };
    }
  }

  onInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    const value = inputTargetValue(target);
    this.setState({ [name]: value });
  };

  stateToValue() {
    const { group, labels } = this.state;
    return {
      group,
      labels: strToLabels(labels),
    };
  }

  render() {
    const { group, labels } = this.state;
    return (
      <form className="form-horizontal" onSubmit={this.onSubmit}>
        <FormInput
          type="text"
          name="group"
          label="Group name"
          value={group}
          onChange={this.onInputChange}
          help="Name of conductor group"
        />
        <LabelsInput
          value={labels}
          onChange={this.onInputChange}
        />
      </form>
    );
  }
}

ClusterHostConductorForm.propTypes = {
  onSubmit: PropTypes.func,
  group: PropTypes.string,
  labels: PropTypes.arrayOf(PropTypes.string),
};

ClusterHostConductorForm.defaultProps = {
  onSubmit: null,
  group: '',
  labels: [],
};

export default ClusterHostConductorForm;
