import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import FormInput from '../../components/forms/FormInput';
import { strToLabels, labelsToStr } from '../../utils/labels';
import { inputTargetValue } from '../../utils/inputs';
import LabelsInput from './LabelsInput';

class ClusterHostConductorTagForm extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      name: props.name,
      labels: labelsToStr(props.labels),
    };
    if (props.onSubmit) {
      this.onSubmit = (event) => {
        event.preventDefault();
        props.onSubmit(this.stateToValue());
      };
    }
  }

  onInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    const value = inputTargetValue(target);
    this.setState({ [name]: value });
  };

  stateToValue() {
    const { name, labels } = this.state;
    return {
      name,
      labels: strToLabels(labels),
    };
  }

  render() {
    const { name, labels } = this.state;
    return (
      <form className="form-horizontal" onSubmit={this.onSubmit}>
        <FormInput
          type="text"
          name="name"
          label="Tag name"
          value={name}
          onChange={this.onInputChange}
          help="Name of conductor tag"
        />
        <LabelsInput
          value={labels}
          onChange={this.onInputChange}
        />
      </form>
    );
  }
}

ClusterHostConductorTagForm.propTypes = {
  onSubmit: PropTypes.func,
  name: PropTypes.string,
  labels: PropTypes.arrayOf(PropTypes.string),
};

ClusterHostConductorTagForm.defaultProps = {
  onSubmit: null,
  name: '',
  labels: [],
};

export default ClusterHostConductorTagForm;
