import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import FormInput from '../../components/forms/FormInput';
import { strToLabels, labelsToStr } from '../../utils/labels';
import { inputTargetValue } from '../../utils/inputs';
import LabelsInput from './LabelsInput';

class ClusterHostInstanceGroupForm extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      instanceGroupId: props.instanceGroupId,
      folderId: props.folderId,
      labels: labelsToStr(props.labels),
    };
    if (props.onSubmit) {
      this.onSubmit = (event) => {
        event.preventDefault();
        props.onSubmit(this.stateToValue());
      };
    }
  }

  onInputChange = (event) => {
    const { target } = event;
    const { name } = target;
    const value = inputTargetValue(target);
    this.setState({ [name]: value });
  };

  stateToValue() {
    const { instanceGroupId, folderId, labels } = this.state;
    return {
      instanceGroupId,
      folderId,
      labels: strToLabels(labels),
    };
  }

  render() {
    const { instanceGroupId, folderId, labels } = this.state;
    return (
      <form className="form-horizontal" onSubmit={this.onSubmit}>
        <FormInput
          type="text"
          name="instanceGroupId"
          label="Instance group ID"
          value={instanceGroupId}
          onChange={this.onInputChange}
        />
        <FormInput
          type="text"
          name="folderId"
          label="Folder ID"
          value={folderId}
          onChange={this.onInputChange}
        />
        <LabelsInput
          value={labels}
          onChange={this.onInputChange}
        />
      </form>
    );
  }
}

ClusterHostInstanceGroupForm.propTypes = {
  onSubmit: PropTypes.func,
  instanceGroupId: PropTypes.string,
  folderId: PropTypes.string,
  labels: PropTypes.arrayOf(PropTypes.string),
};

ClusterHostInstanceGroupForm.defaultProps = {
  onSubmit: null,
  instanceGroupId: '',
  folderId: '',
  labels: [],
};

export default ClusterHostInstanceGroupForm;
