import React from 'react';
import PropTypes from 'prop-types';
import FormInput from '../../components/forms/FormInput';

const LabelsInput = ({ value, onChange }) => (
  <FormInput
    type="text"
    name="labels"
    label="Labels"
    value={value}
    onChange={onChange}
    help="One or more optional labels that will be used in aggregation rules
                for metrics fetched from these hosts.
                Labels must be written in a 'key=value' format delimited by a space (e.g. 'env=prod dc=man')"
  />
);

LabelsInput.propTypes = {
  value: PropTypes.string,
  onChange: PropTypes.func.isRequired,
};

LabelsInput.defaultProps = {
  value: '',
};

export default LabelsInput;
