import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Modal from '../../components/Modal';

class ResolvedHostsModal extends PureComponent {
  onHideResolvedCluster = (event) => {
    if (event) {
      event.preventDefault();
    }
    this.props.onClearResolvedCluster();
  };

  render() {
    let resolvedHostsModal = null;

    if (this.props.resolvedCluster.data) {
      const resolvedHosts = this.props.resolvedCluster.data.results.map((result) => (
        <div>
          <h3>{result.groupName || '<empty>'}</h3>
          {!!result.errorMessage && (
            <pre>{result.errorMessage}</pre>
          )}
          {!!result.hosts && (
            <table className="table table-considered table-hover table-responsive">
              <thead>
                <tr>
                  <th>#</th>
                  <th>FQDN</th>
                  <th>Port</th>
                  <th>Labels</th>
                </tr>
              </thead>
              <tbody>
                {result.hosts.map((row, rowIndex) => (
                  // eslint-disable-next-line react/no-array-index-key
                  <tr key={rowIndex}>
                    <td>{rowIndex + 1}</td>
                    <td>{row.fqdn || '-'}</td>
                    <td>{row.port || '-'}</td>
                    <td>{row.labels || '-'}</td>
                  </tr>
                ))}
              </tbody>
            </table>
          )}
        </div>
      ));

      resolvedHostsModal = (
        <Modal title="Resolved hosts" isOpen onCancel={this.onHideResolvedCluster}>
          {resolvedHosts}
        </Modal>
      );
    }

    return resolvedHostsModal;
  }
}

ResolvedHostsModal.propTypes = {
  resolvedCluster: PropTypes.object.isRequired,
  onClearResolvedCluster: PropTypes.func.isRequired,
};

export default ResolvedHostsModal;
