/* eslint-disable react/no-string-refs */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import FormInput from '../../components/forms/FormInput';

import { makeShardId } from '../shards/ShardForm';
import FormDatalist from '../../components/forms/FormDatalist';

class ShardModalForm extends PureComponent {
  constructor(props) {
    super(props);
    this._projectId = props.projectId;
    this._clusterId = props.clusterId;
    this._idFieldTouched = false;
    this.state = { id: '', serviceId: '' };
  }

  componentDidMount() {
    this.refs.serviceField.focus();
  }

  onSubmit = (event) => {
    event.preventDefault();
    this.props.onSubmit();
  };

  onShardIdChange = (event) => {
    this._idFieldTouched = true;
    this.setState({ id: event.target.value });
  };

  onServiceIdChange = (event) => {
    const serviceId = event.target.value;
    const newState = { serviceId };
    if (!this._idFieldTouched) {
      newState.id = makeShardId(this._projectId, this._clusterId, serviceId);
    }
    this.setState(newState);
  };

  stateToValue() {
    const { id, serviceId } = this.state;
    return {
      id, projectId: this._projectId, serviceId, clusterId: this._clusterId,
    };
  }

  render() {
    const { services, errorMessage } = this.props;
    const { id, serviceId } = this.state;

    return (
      <form className="form-horizontal" onSubmit={this.onSubmit}>
        {errorMessage && (
          <div className="alert alert-danger">{errorMessage}</div>
        )}
        <FormDatalist
          label="Service"
          help="Unique service identifier"
          name="serviceId"
          value={serviceId}
          datalist={services}
          ref="serviceField"
          onChange={this.onServiceIdChange}
        />
        <FormInput
          type="text"
          name="id"
          label="Id"
          help="Unique shard identifier. It is composed from project, cluster and service id automatically"
          value={id}
          onChange={this.onShardIdChange}
        />
      </form>
    );
  }
}

ShardModalForm.propTypes = {
  onSubmit: PropTypes.func.isRequired,
  projectId: PropTypes.string.isRequired,
  clusterId: PropTypes.string.isRequired,
  services: PropTypes.array.isRequired,
  errorMessage: PropTypes.string.isRequired,
};

export default ShardModalForm;
