/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { parseStockpileMetricAsTable } from './exportUtils';
import SimplePagination from '../../../components/Pagination/SinglePagination';

const POINTS_PAGE_SIZE = 200;

class AggrPointsTable extends PureComponent {
  render() {
    const { columns, points, activePage } = this.props;

    if (columns.length === 0 || points.length === 0) {
      return null;
    }

    const pageCount = Math.ceil(points.length / POINTS_PAGE_SIZE);

    const offset = (activePage - 1) * POINTS_PAGE_SIZE;
    const pagePoints = points.slice(offset, offset + POINTS_PAGE_SIZE);

    const tableData = parseStockpileMetricAsTable(pagePoints, columns);

    return (
      <div>
        <table className="table table-condensed table-hover">
          <thead>
            <tr>
              <th>#</th>
              {tableData.columns.map((column) => <th key={column}>{column}</th>)}
            </tr>
          </thead>
          <tbody>
            {tableData.rows.map((row, rowIndex) => (
              <tr key={rowIndex}>
                <td>{offset + rowIndex + 1}</td>
                {row.map((value, colIndex) => (
                  <td key={colIndex}>
                    {`${value}`}
                  </td>
                ))}
              </tr>
            ))}
          </tbody>
        </table>
        <SimplePagination
          activePage={activePage}
          pageCount={pageCount}
          onActivePageChange={this.props.onChangeActivePage}
        />
      </div>
    );
  }
}

AggrPointsTable.propTypes = {
  columns: PropTypes.array.isRequired,
  points: PropTypes.array.isRequired,
  activePage: PropTypes.number.isRequired,
  onChangeActivePage: PropTypes.func.isRequired,
};

export default AggrPointsTable;
