import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';

function getApiHostname() {
  const { hostname } = window.location;
  if (hostname === 'localhost') {
    return 'localhost:5540';
  }
  return hostname.replace('yandex-team.ru', 'yandex.net');
}

function curlExample(projectId, urlParams) {
  return `$ curl \\
      -H 'Content-Type: application/json' \\
      -H 'Accept: application/json' \\
      -H 'Authorization: OAuth <YOUR_TOKEN>' \\
      'http://${getApiHostname()}/api/internal/projects/${projectId}/stockpile/sensor?${urlParams}'`;
}

class DataApiModal extends PureComponent {
  render() {
    const { projectId, urlParams, isOpen } = this.props;
    const example = curlExample(projectId, urlParams);

    return (
      <ReactModal
        className="modal-dialog"
        contentLabel="Modal"
        isOpen={isOpen}
        onRequestClose={this.props.onCancel}
      >
        <div className="modal-content modal-lg">
          <div className="modal-header">
            <button type="button" className="close" onClick={this.props.onCancel}>
              <span>&times;</span>
            </button>
            <h4 className="modal-title">Data API command</h4>
          </div>
          <div className="modal-body">
            <pre>
              {example}
            </pre>
          </div>
          <div className="modal-footer">
            <button type="button" className="btn btn-outline btn-default" onClick={this.props.onCancel}>
              Close
            </button>
          </div>
        </div>
      </ReactModal>
    );
  }
}

DataApiModal.propTypes = {
  projectId: PropTypes.string.isRequired,
  urlParams: PropTypes.string.isRequired,
  isOpen: PropTypes.bool.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default DataApiModal;
