import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class LabelsSelector extends PureComponent {
  constructor(props) {
    super(props);

    this.state = { labels: props.labels };
  }

  componentDidUpdate(prevProps) {
    if (this.props.labels !== prevProps.labels) {
      this.setState({ labels: this.props.labels });
    }
  }

  handleChange = (event) => {
    this.setState({ labels: event.target.value });
  };

  handleKeyPress = (event) => {
    if (event.which === 13) {
      event.preventDefault();
      if (this.state.labels) {
        this.props.onChange(this.state.labels);
      }
    }
  };

  render() {
    const { labels } = this.state;

    return (
      <div className="form">
        <input
          className="form-control"
          value={labels}
          onChange={this.handleChange}
          onKeyPress={this.handleKeyPress}
          placeholder="Labels..."
        />
      </div>
    );
  }
}

LabelsSelector.propTypes = {
  labels: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
};

export default LabelsSelector;
