/* eslint-disable jsx-a11y/no-static-element-interactions */
/* eslint-disable jsx-a11y/no-noninteractive-element-interactions */
/* eslint-disable jsx-a11y/anchor-is-valid */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { convertToCsv, downloadFile } from './exportUtils';
import DataApiModal from './DataApiModal';

class MoreDropdownButton extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { dropdownShown: false, modalShown: false };
  }

  createFileName = () => {
    const { projectId } = this.props;
    const { labels, forceCluster } = this.props.state;

    return `${projectId}-${labels}${forceCluster ? `-${forceCluster}` : ''}`;
  };

  handleClick = (event) => {
    event.stopPropagation();
    event.preventDefault();
    this.setState({ dropdownShown: !this.state.dropdownShown });
  };

  handleBlur = (event) => {
    event.preventDefault();
    this.setState({ dropdownShown: false });
  };

  handleExportToJsonClick = (event) => {
    this.handleBlur(event);

    const content = JSON.stringify(this.props.stockpileMetric);

    const filename = `${this.createFileName()}.json`;

    downloadFile(filename, content);
  };

  handleExportToCsvClick = (event) => {
    this.handleBlur(event);

    const content = convertToCsv(this.props.stockpileMetric);

    const filename = `${this.createFileName()}.csv`;

    downloadFile(filename, content);
  };

  handleShowDataApiClick = (event) => {
    this.handleBlur(event);
    this.setState({ modalShown: true });
  };

  handleModalCancel = () => {
    this.setState({ modalShown: false });
  };

  render() {
    const { projectId, urlParams } = this.props;

    const dataApiModal = (
      <DataApiModal
        projectId={projectId}
        urlParams={urlParams}
        isOpen={this.state.modalShown}
        onCancel={this.handleModalCancel}
      />
    );

    return (
      <div className={`btn-group dropdown${this.state.dropdownShown ? ' open' : ''}`}>
        <button
          type="button"
          className="btn btn-default dropdown-toggle"
          data-toggle="dropdown"
          onClick={this.handleClick}
          onBlur={this.handleBlur}
        >
          More
          {' '}
          <span className="caret" />
        </button>
        <ul className="dropdown-menu dropdown-menu-right">
          <li onMouseDown={this.handleExportToJsonClick}><a role="button">Export to JSON</a></li>
          <li onMouseDown={this.handleExportToCsvClick}><a role="button">Export to CSV</a></li>
          <li role="separator" className="divider" />
          <li onMouseDown={this.handleShowDataApiClick}><a role="button">Show Data API command</a></li>
        </ul>
        {dataApiModal}
      </div>
    );
  }
}

MoreDropdownButton.propTypes = {
  projectId: PropTypes.string.isRequired,
  state: PropTypes.object.isRequired,
  urlParams: PropTypes.string.isRequired,
  stockpileMetric: PropTypes.object,
};

MoreDropdownButton.defaultProps = {
  stockpileMetric: null,
};

export default MoreDropdownButton;
