import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { formatISO8601 } from '../../../utils/iso8601';

const STOCKPILE_PORT = 4500;

class StockpileKeysPanel extends PureComponent {
  render() {
    const {
      projectId, labels, b, e, forceCluster, keys,
    } = this.props;

    if (!keys || keys.length === 0) {
      return null;
    }

    const dropForceClusterUrl = `/admin/projects/${projectId}/stockpileMetric?${new URLSearchParams({ labels, b, e }).toString()}`;

    const fromParam = formatISO8601(this.props.fromMillis);
    const toParam = formatISO8601(this.props.toMillis);

    return (
      <div>
        Stockpile keys:
        <ul>
          {keys.map((key) => {
            const forceClusterParams = new URLSearchParams({
              labels, b, e, forceCluster: key.destination || '',
            });

            const forceClusterUrl = `/admin/projects/${projectId}/stockpileMetric?${forceClusterParams.toString()}`;

            const clusterTitle = key.destination || 'unknown';

            const shardUrl = `/staffOnly/${key.host}:${STOCKPILE_PORT}/manager?bean=${key.shardId}&class=ru.yandex.stockpile.server.shard.StockpileShard`;
            const diskEntryProtoUrl = `/staffOnly/${key.host}:${STOCKPILE_PORT}/manager?class=ru.yandex.stockpile.server.shard.StockpileShardInspector&bean=${key.shardId}&method=getDiskEntryProto&desc=%28Ljava%2Flang%2FString%3B%29Ljava%2Futil%2Fconcurrent%2FCompletableFuture%3B&invoke=1&p0=${key.localId}`;
            const fullCacheEntryProtoUrl = `/staffOnly/${key.host}:${STOCKPILE_PORT}/manager?class=ru.yandex.stockpile.server.shard.StockpileShardInspector&bean=${key.shardId}&method=getCacheEntryProto&desc=%28Ljava%2Flang%2FString%3B%29Ljava%2Futil%2Fconcurrent%2FCompletableFuture%3B&invoke=1&p0=${key.localId}`;
            const intervalCacheEntryProtoUrl = `/staffOnly/${key.host}:${STOCKPILE_PORT}/manager?class=ru.yandex.stockpile.server.shard.StockpileShardInspector&bean=${key.shardId}&method=getCacheEntryProto&desc=%28Ljava%2Flang%2FString%3BLjava%2Flang%2FString%3BLjava%2Flang%2FString%3B%29Ljava%2Futil%2Fconcurrent%2FCompletableFuture%3B&invoke=1&p0=${key.localId}&p1=${fromParam}&p2=${toParam}`;

            return (
              <li key={key.destination}>
                <a href={forceClusterUrl}>{clusterTitle}</a>
                :
                shardId=
                <a href={shardUrl}>{key.shardId}</a>
                , localId=
                {key.localId}
                &nbsp;
                {/* eslint-disable-next-line max-len */}
                (
                <a href={diskEntryProtoUrl}>disk</a>
                ,
                {' '}
                <a href={intervalCacheEntryProtoUrl}>cache by interval</a>
                ,
                {' '}
                <a href={fullCacheEntryProtoUrl}>full cache</a>
                )
              </li>
            );
          })}
          {forceCluster
            ? <li><a href={dropForceClusterUrl}>Don&apos;t force cluster</a></li>
            : null}
        </ul>
      </div>
    );
  }
}

StockpileKeysPanel.propTypes = {
  projectId: PropTypes.string.isRequired,
  labels: PropTypes.string.isRequired,
  b: PropTypes.string.isRequired,
  e: PropTypes.string.isRequired,
  fromMillis: PropTypes.string.isRequired,
  toMillis: PropTypes.string.isRequired,
  forceCluster: PropTypes.string.isRequired,
  keys: PropTypes.array,
};

StockpileKeysPanel.defaultProps = {
  keys: [],
};

export default StockpileKeysPanel;
