import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import RadioButtons from '../../../components/RadioButtons';
import {
  alignToNow, goBackward, goForward, zoomIn, zoomOut,
} from './navs';

function mapBeginToRange(b) {
  switch (b) {
    case '1h': return 'hour';
    case '1d': return 'day';
    case '7d':
    case '1w': return 'week';
    case '31d': return 'month';
    case '365d': return 'year';
    default: return '';
  }
}

function mapRangeToBegin(range) {
  switch (range) {
    case 'hour': return '1h';
    case 'day': return '1d';
    case 'week': return '1w';
    case 'month': return '31d';
    case 'year': return '365d';
    default: return '';
  }
}

class TimeBar extends PureComponent {
  handlePrevClick = (event) => {
    event.preventDefault();

    const { fromMillis, toMillis } = this.props;

    const { b, e } = goBackward(fromMillis, toMillis);

    return this.props.onRangeChange(b, e);
  };

  handleNextClick = (event) => {
    event.preventDefault();

    const { fromMillis, toMillis } = this.props;

    const { b, e } = goForward(fromMillis, toMillis);

    return this.props.onRangeChange(b, e);
  };

  handleZoomInClick = (event) => {
    event.preventDefault();

    const {
      fromMillis, toMillis, b, e,
    } = this.props;

    const { b: newB, e: newE } = zoomIn(b, e, fromMillis, toMillis);

    return this.props.onRangeChange(newB, newE);
  };

  handleZoomOutClick = (event) => {
    event.preventDefault();

    const {
      fromMillis, toMillis, b, e,
    } = this.props;

    const { b: newB, e: newE } = zoomOut(b, e, fromMillis, toMillis);

    return this.props.onRangeChange(newB, newE);
  };

  handleNowClick = (event) => {
    event.preventDefault();

    const { b, e } = alignToNow(this.props.fromMillis, this.props.toMillis);

    this.props.onRangeChange(b, e);
  };

  handleRangeChange = (range) => {
    this.props.onRangeChange(mapRangeToBegin(range), '');
  };

  render() {
    let range = '';
    let isNowActive = false;

    if (this.props.e === '') {
      range = mapBeginToRange(this.props.b);
      isNowActive = true;
    }

    return (
      <div className="datetime-control btn-toolbar">
        <div className="btn-group">
          <button
            type="button"
            className={`btn ${isNowActive ? 'btn-primary' : 'btn-default'}`}
            onClick={this.handleNowClick}
          >
            Now
          </button>
        </div>
        <div className="btn-group">
          <button type="button" className="btn btn-default" onClick={this.handlePrevClick}>＜＜</button>
          <button type="button" className="btn btn-default" onClick={this.handleNextClick}>＞＞</button>
        </div>
        <div className="btn-group">
          <button type="button" className="btn btn-default" onClick={this.handleZoomInClick}>+</button>
          <button type="button" className="btn btn-default" onClick={this.handleZoomOutClick}>－</button>
        </div>
        <RadioButtons
          choices={['hour', 'day', 'week', 'month', 'year']}
          labels={['Hour', 'Day', 'Week', 'Month', 'Year']}
          selected={range}
          onSelect={this.handleRangeChange}
          primary
        />
      </div>
    );
  }
}

TimeBar.propTypes = {
  b: PropTypes.string.isRequired,
  e: PropTypes.string.isRequired,
  fromMillis: PropTypes.number.isRequired,
  toMillis: PropTypes.number.isRequired,
  onRangeChange: PropTypes.func.isRequired,
};

export default TimeBar;
