import { formatISO8601 } from '../../../utils/iso8601';
import { formatDuration, parseDuration } from '../../../utils/duration';

export function goBackward(fromMillis, toMillis) {
  const duration = toMillis - fromMillis;
  const nextFromMillis = fromMillis - duration;
  const nextToMillis = fromMillis;

  const b = formatISO8601(nextFromMillis);
  const e = formatISO8601(nextToMillis);

  return { b, e };
}

export function goForward(fromMillis, toMillis) {
  const duration = toMillis - fromMillis;
  const nextFromMillis = toMillis;
  const nextToMillis = toMillis + duration;

  const b = formatISO8601(nextFromMillis);
  const e = formatISO8601(nextToMillis);

  return { b, e };
}

export function zoomIn(b, e, fromMillis, toMillis) {
  let newB;
  let newE;

  if (parseDuration(b) !== null && e === '') {
    const halfDuration = Math.round((toMillis - fromMillis) / 2);
    newB = formatDuration(halfDuration);
    newE = '';
  } else {
    const quarterDuration = Math.round((toMillis - fromMillis) / 4);

    const nextFromMillis = fromMillis + quarterDuration;
    const nextToMillis = toMillis - quarterDuration;

    newB = formatISO8601(nextFromMillis);
    newE = formatISO8601(nextToMillis);
  }

  return { b: newB, e: newE };
}

export function zoomOut(b, e, fromMillis, toMillis) {
  let newB;
  let newE;

  if (parseDuration(b) !== null && e === '') {
    const doubleDuration = Math.round((toMillis - fromMillis) * 2);
    newB = formatDuration(doubleDuration);
    newE = '';
  } else {
    const quarterDuration = Math.round((toMillis - fromMillis) / 4);

    const nextFromMillis = fromMillis - quarterDuration;
    const nextToMillis = toMillis + quarterDuration;

    newB = formatISO8601(nextFromMillis);
    newE = formatISO8601(nextToMillis);
  }

  return { b: newB, e: newE };
}

export function alignToNow(fromMillis, toMillis) {
  const range = formatDuration(toMillis - fromMillis);

  return { b: range, e: '' };
}
