import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import RadioButtons from '../../components/RadioButtons';
import FormElement from '../../components/forms/FormElement';

class FormRadioGroup extends PureComponent {
  onChange = (value) => {
    const event = { target: { name: this.props.name, value } };
    this.props.onChange(event);
  };

  render() {
    return (
      <FormElement label={this.props.label} help={this.props.help}>
        <RadioButtons
          labels={this.props.options.map((o) => o.title)}
          choices={this.props.options.map((o) => o.value)}
          selected={this.props.value || this.props.defaultValue}
          onSelect={this.onChange}
        />
      </FormElement>
    );
  }
}

FormRadioGroup.propTypes = {
  name: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  value: PropTypes.string,
  defaultValue: PropTypes.string,
  options: PropTypes.array.isRequired,
  help: PropTypes.oneOfType([PropTypes.string, PropTypes.element]),
  onChange: PropTypes.func.isRequired,
};

FormRadioGroup.defaultProps = {
  value: null,
  defaultValue: null,
  help: null,
};

export default FormRadioGroup;
