import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import * as NUMBER_FORMAT from './NumberFormatUtils';

const _getTitleByValue = (value, options) => {
  const filtered = options.filter((o) => o.value === value);
  return filtered.length !== 1 ? 'unknown' : filtered[0].title;
};

class NumberFormatReadonly extends PureComponent {
  render() {
    const { precision, multiplier } = NUMBER_FORMAT.parseNumberFormat(this.props.value);
    const precisionTitle = _getTitleByValue(precision, NUMBER_FORMAT.PRECISIONS);
    const multiplierTitle = _getTitleByValue(multiplier, NUMBER_FORMAT.MULTIPLIERS);

    return (
      <div>
        <span className="label label-primary">{precisionTitle}</span>
        &nbsp;
        <span className="label label-info">{multiplierTitle}</span>
      </div>
    );
  }
}

NumberFormatReadonly.propTypes = {
  value: PropTypes.string,
};

NumberFormatReadonly.defaultProps = {
  value: '',
};

export default NumberFormatReadonly;
