import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import * as NumberFormat from './NumberFormatUtils';

class NumberFormatSelector extends PureComponent {
  onPrecisionChange = (event) => {
    const { value } = event.target;
    const { multiplier } = NumberFormat.parseNumberFormat(this.props.value);
    const result = NumberFormat.serializeNumberFormat(value, multiplier);
    this.props.onChange(result);
  };

  onMultiplierChange = (event) => {
    const { value } = event.target;
    const { precision } = NumberFormat.parseNumberFormat(this.props.value);
    const result = NumberFormat.serializeNumberFormat(precision, value);
    this.props.onChange(result);
  };

  render() {
    const { precision, multiplier } = NumberFormat.parseNumberFormat(this.props.value);
    return (
      <div className="row">
        <div className="col-sm-6">
          <select
            className="form-control"
            value={precision}
            onChange={this.onPrecisionChange}
          >
            {NumberFormat.PRECISIONS.map((option, index) => (
              // eslint-disable-next-line react/no-array-index-key
              <option key={index} value={option.value}>
                {option.title}
              </option>
            ))}
          </select>
        </div>
        <div className="col-sm-6">
          <select
            className="form-control"
            value={multiplier}
            onChange={this.onMultiplierChange}
          >
            {NumberFormat.MULTIPLIERS.map((option, index) => (
              // eslint-disable-next-line react/no-array-index-key
              <option key={index} value={option.value}>
                {option.title}
              </option>
            ))}
          </select>
        </div>
      </div>
    );
  }
}

NumberFormatSelector.propTypes = {
  value: PropTypes.string,
  onChange: PropTypes.func.isRequired,
};

NumberFormatSelector.defaultProps = {
  value: '',
};

export default NumberFormatSelector;
