const DEFAULT_PRECISION = 3;
const DEFAULT_MULTIPLIER = 'auto';

const DEFAULT_NUMBER_FORMAT = {
  precision: DEFAULT_PRECISION,
  multiplier: DEFAULT_MULTIPLIER,
};

// eslint-disable-next-line no-use-before-define,max-len
export const DEFAULT_NUMBER_FORMAT_VALUE = serializeNumberFormat(DEFAULT_PRECISION, DEFAULT_MULTIPLIER);

export const PRECISIONS = [
  { value: 0, title: '1' },
  { value: 1, title: '1.1' },
  { value: 2, title: '1.12' },
  { value: 3, title: '1.123' },
  { value: 4, title: '1.1235' },
  { value: 5, title: '1.12346' },
  { value: 6, title: '1.123457' },
  { value: 7, title: '1.1234568' },
  { value: 8, title: '1.12345679' },
];

export const MULTIPLIERS = [
  { value: 'auto', title: 'Like Y-axis' },
  { value: 'p', title: 'p (10^-12)' },
  { value: 'n', title: 'n (10^-9)' },
  { value: 'u', title: 'μ (10^-6)' },
  { value: 'm', title: 'm (10^-3)' },
  { value: '', title: ' (10^0)' },
  { value: 'K', title: 'K (10^3)' },
  { value: 'M', title: 'M (10^6)' },
  { value: 'G', title: 'G (10^9)' },
  { value: 'T', title: 'T (10^12)' },
  { value: 'P', title: 'P (10^15)' },
  { value: 'E', title: 'E (10^18)' },
];

const MULTIPLIER_VALUES = MULTIPLIERS.map((m) => m.value);

export function parseNumberFormat(value) {
  if (!value || value.indexOf('|') < 0) {
    return DEFAULT_NUMBER_FORMAT;
  }

  let parts = value.split('|');
  if (parts.length === 1 && value.endsWith('|')) {
    parts = [parts[0], ''];
  }

  if (parts.length !== 2) {
    return DEFAULT_NUMBER_FORMAT;
  }

  let precision = parseInt(parts[0], 10);

  if (isNaN(precision)) {
    precision = DEFAULT_PRECISION;
  }

  let multiplier;
  if (MULTIPLIER_VALUES.indexOf(parts[1]) >= 0) {
    multiplier = parts[1];
  } else {
    multiplier = DEFAULT_MULTIPLIER;
  }

  return { precision, multiplier };
}

export function serializeNumberFormat(precision, multiplier) {
  return `${precision}|${multiplier}`;
}
